{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:35:47 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
{$IFDEF WIN32}
  Windows,
{$ELSE}
  WinTypes,
  WinProcs,
{$ENDIF}
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  ExtCtrls,
  MMSystem,
  MMRingBf,
  MMACMCvt,
  MMDSPObj,
  MMTrigg,
  MMWave,
  MMObj,
  MMUtils,
  MMCstDlg,
  MMDesign,
  MMConect,
  MMGauge,
  MMDIBCv,
  MMSpGram,
  MMHook,
  MMLevel,
  MMEQ,
  MMWavOut,
  MMSlider;
  
type
  TMainForm = class(TForm)
    Connector: TMMConnector;
    MMDesigner1: TMMDesigner;
    btnStop: TButton;
    btnPlay: TButton;
    btnFile: TButton;
    WaveOpenDialog: TMMWaveOpenDialog;
    SourceFile: TMMWaveFile;
    Trigger: TMMTrigger;
    Gauge: TMMGauge;
    WaveOut: TMMWaveOut;
    EQ: TMMEqualizer;
    btnSave: TButton;
    MMLevel1: TMMLevel;
    MMLevel2: TMMLevel;
    Panel6: TPanel;
    Label2: TLabel;
    Label3: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    dbLabel0: TLabel;
    dBLabel1: TLabel;
    dBLabel2: TLabel;
    dbLabel3: TLabel;
    dBLabel4: TLabel;
    dBLabel5: TLabel;
    dBLabel6: TLabel;
    dBLabel7: TLabel;
    dBLabel8: TLabel;
    dBLabel9: TLabel;
    MMSlider16: TMMSlider;
    MMSlider17: TMMSlider;
    MMSlider18: TMMSlider;
    MMSlider19: TMMSlider;
    MMSlider20: TMMSlider;
    MMSlider21: TMMSlider;
    MMSlider22: TMMSlider;
    MMSlider23: TMMSlider;
    MMSlider29: TMMSlider;
    MMSlider15: TMMSlider;
    WaveSaveDialog: TMMWaveSaveDialog;
    DestFile: TMMWaveFile;
    MMPCMConverter1: TMMPCMConverter;
    procedure btnPlayClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnFileClick(Sender: TObject);
    procedure DeviceOpen(Sender: TObject);
    procedure DeviceStop(Sender: TObject);
    procedure DeviceBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
    procedure FormCreate(Sender: TObject);
    procedure SliderChange(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
  private
  public
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

type
  TBand  = record
    f1     : Float;
    f2     : Float;
    dbLbl  : TLabel;
  end;

const
  nBands = 10;
  EQBands: array[0..nBands-1] of TBand =
           ((f1:    0; f2:    32; dbLbl: nil),
            (f1:   32; f2:    64; dbLbl: nil),
            (f1:   64; f2:   130; dbLbl: nil),
            (f1:  130; f2:   260; dbLbl: nil),
            (f1:  260; f2:   500; dbLbl: nil),
            (f1:  500; f2:  1000; dbLbl: nil),
            (f1: 1000; f2:  2000; dbLbl: nil),
            (f1: 2000; f2:  4000; dbLbl: nil),
            (f1: 4000; f2:  8300; dbLbl: nil),
            (f1: 8300; f2: 16500; dbLbl: nil));

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormCreate(Sender: TObject);
var
   i: integer;
begin
   { a simple example how to setup the bands at runtime }

   for i := 0 to nBands-1 do
   with EQBands[i] do
   begin
      EQ.Filters.AddObject(TMMEQFilter.CreateEx(f1,f2,0));
      dBLbl := TLabel(FindComponent('dBLabel'+IntToStr(i)));
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   WaveOut.Close;
   Trigger.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnFileClick(Sender: TObject);
begin
   if WaveOpenDialog.Execute then
   begin
      SourceFile.LoadFromFile(WaveOpenDialog.FileName);
      btnPlay.Enabled := True;
      btnSave.Enabled := True;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnPlayClick(Sender: TObject);
begin
   if not SourceFile.Wave.Empty then
   begin
      WaveOut.Input := EQ;
      WaveOut.Start;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnSaveClick(Sender: TObject);
begin
   if not SourceFile.Wave.Empty then
   begin
      if WaveSaveDialog.Execute then
      begin
         if (WaveSaveDialog.FileName = SourceFile.Wave.FileName) then
         begin
            MessageDlg('Source and Destination must be different !', mtError, [mbOK], 0);
            exit;
         end;
         DestFile.Wave.FileName := WaveSaveDialog.FileName;
         Trigger.Input := EQ;
         Trigger.Start;
      end;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnStopClick(Sender: TObject);
begin
   WaveOut.Stop;
   Trigger.Stop;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.DeviceOpen(Sender: TObject);
begin
   btnPlay.Enabled := False;
   btnSave.Enabled := False;
   btnStop.Enabled := True;
   btnFile.Enabled := False;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.DeviceStop(Sender: TObject);
begin
   WaveOut.Close;
   Trigger.Close;
   Gauge.Progress := 0;
   btnPlay.Enabled := True;
   btnSave.Enabled := True;
   btnStop.Enabled := False;
   btnFile.Enabled := True;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.DeviceBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
begin
   Gauge.Progress := Trunc(SourceFile.Wave.Position*100/SourceFile.Wave.DataSize);
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.SliderChange(Sender: TObject);
begin
   with (Sender as TMMSlider) do
   begin
      EQ.Filters[Tag].Gain := Position;
      EQBands[Tag].dbLbl.Caption := IntToStr(Position);
   end;
end;

end.
